# SmartINBOX

Modern Email for Teams and Professionals. A replacement for outdated email technology and tools.

## Overview

SmartINBOX is a modern email platform designed for teams and professionals. It provides a better way to manage your email communications with features like team collaboration, workflow management, and multiple email address support.

## Features

- **Team Collaboration**: Share inboxes with your team and collaborate on email conversations
- **Workflow Management**: Track emails with workflow statuses so everyone knows when tasks are complete
- **Multiple Email Addresses**: Add unlimited email addresses for your organization
- **Secure Communications**: End-to-end encryption ensures your email communications remain private and secure

## Installation Requirements

- CloudLinux VPS with cPanel
- PHP 8.2 or higher
- Node.js 20.x or higher
- MariaDB 11.4 or higher
- Apache 2.4 or higher
- Redis (optional but recommended)

## Installation Instructions

### 1. Download the Installation Package

Download the SmartINBOX installation package and extract it to your server:

```bash
cd /home/smartersweb
wget https://example.com/smartinbox.zip
unzip smartinbox.zip
cd smartinbox
```

### 2. Run the Installation Script

Run the installation script as root:

```bash
chmod +x install.sh
sudo ./install.sh
```

The script will:
- Check for required dependencies
- Create necessary directories
- Copy files to the installation directory
- Install Node.js dependencies
- Create service files
- Start the SmartINBOX service

### 3. Configure Your Domain

In cPanel:
1. Go to **Domains** or **Subdomains**
2. Create a subdomain (e.g., smartinbox.yourdomain.com) or use an existing domain
3. Point it to the `/home/yourusername/public_html/smartinbox` directory

### 4. Configure SSL (Recommended)

In cPanel:
1. Go to **SSL/TLS**
2. Install an SSL certificate for your domain/subdomain
3. Enable HTTPS for your site

### 5. Test Your Installation

Visit your domain/subdomain in a web browser:
```
https://smartinbox.yourdomain.com
```

## Manual Start/Stop

If you need to manually start or stop the SmartINBOX service:

```bash
# Using systemd
sudo systemctl start smartinbox.service
sudo systemctl stop smartinbox.service
sudo systemctl restart smartinbox.service
sudo systemctl status smartinbox.service

# Using the provided scripts
cd /home/yourusername/public_html/smartinbox
./start.sh
./stop.sh
```

## Using PM2 (Alternative)

If you prefer using PM2 for process management:

```bash
# Install PM2 if not already installed
npm install -g pm2

# Start using PM2
cd /home/yourusername/public_html/smartinbox
pm2 start ecosystem.config.js

# Other PM2 commands
pm2 stop smartinbox
pm2 restart smartinbox
pm2 status
pm2 logs smartinbox
```

## Troubleshooting

### Check Service Status

```bash
sudo systemctl status smartinbox.service
```

### View Service Logs

```bash
sudo journalctl -u smartinbox.service
```

### Check Application Logs

```bash
cat /home/yourusername/public_html/smartinbox/logs/server.out
cat /home/yourusername/public_html/smartinbox/logs/server.err
```

### Common Issues

1. **Service won't start**: Check the logs for errors. Make sure Node.js is installed and the server.js file exists.
2. **Cannot access the website**: Check your Apache configuration and make sure the .htaccess file is properly set up.
3. **API calls failing**: Make sure the Node.js service is running and the proxy settings in .htaccess are correct.

## Updating SmartINBOX

To update SmartINBOX to a newer version:

```bash
cd /home/yourusername/public_html/smartinbox
sudo systemctl stop smartinbox.service
cp -r /path/to/new/version/* .
npm install
sudo systemctl start smartinbox.service
```

## License

SmartINBOX is licensed under the AGPL-3.0 License.

## Support

For support, please contact support@smartinbox.com or visit our website at https://www.smartinbox.com.