# SmartINBOX Installation Guide

This guide provides detailed instructions for installing SmartINBOX on a CloudLinux VPS with cPanel.

## System Requirements

- CloudLinux VPS with cPanel
- PHP 8.2 or higher
- Node.js 20.x or higher
- MariaDB 11.4 or higher
- Apache 2.4 or higher
- Redis (optional but recommended)

## Pre-Installation Checklist

Before installing SmartINBOX, ensure that:

1. You have root or sudo access to your server
2. All required ports are open (80, 443, 25, 143, 993, 587)
3. PHP 8.2 is installed and configured
4. Node.js 20.x is installed
5. MariaDB 11.4 is installed and running
6. Apache is configured with mod_rewrite and mod_proxy enabled

## Installation Options

The SmartINBOX installer supports several options to customize your installation:

| Option | Description | Default |
|--------|-------------|---------|
| `--clean` | Perform a clean installation (removes existing files) | false |
| `--domain=DOMAIN` | Set the domain name | smartersweb.host |
| `--subdomain=SUBDOMAIN` | Set the subdomain name | smartinbox |
| `--install-dir=DIR` | Set the installation directory | /home/smartersweb/public_html/smartinbox |
| `--web-user=USER` | Set the web server user | smartersweb |
| `--web-group=GROUP` | Set the web server group | smartersweb |
| `--help` | Show help message | - |

## Installation Steps

### 1. Download the Installation Package

Download the SmartINBOX installation package and extract it to your server:

```bash
cd /home/yourusername
wget https://example.com/smartinbox_fixed.zip
unzip smartinbox_fixed.zip
cd fixed_smartinbox
```

### 2. Make the Installation Script Executable

```bash
chmod +x improved_install.sh
```

### 3. Run the Installation Script

#### Standard Installation

For a standard installation using default settings:

```bash
sudo ./improved_install.sh
```

#### Clean Installation

If you're reinstalling or encountering issues with an existing installation:

```bash
sudo ./improved_install.sh --clean
```

#### Custom Installation

To customize your installation:

```bash
sudo ./improved_install.sh --domain=yourdomain.com --subdomain=mail --install-dir=/path/to/installation --web-user=apache --web-group=apache
```

### 4. Configure Your Domain in cPanel

1. Log in to your cPanel account
2. Navigate to **Domains** or **Subdomains**
3. Create a subdomain (e.g., smartinbox.yourdomain.com) or use an existing domain
4. Point it to the installation directory (e.g., `/home/yourusername/public_html/smartinbox`)

### 5. Configure SSL (Recommended)

1. In cPanel, go to **SSL/TLS**
2. Install an SSL certificate for your domain/subdomain
3. Enable HTTPS for your site

## Post-Installation Configuration

### Email Server Configuration

To configure the email server integration:

1. Edit the `.env` file in your installation directory:
   ```bash
   nano /home/yourusername/public_html/smartinbox/.env
   ```

2. Update the email configuration section:
   ```
   # Email Configuration
   SMTP_HOST=your-smtp-server.com
   SMTP_PORT=587
   SMTP_SECURE=true
   SMTP_USER=your-smtp-username
   SMTP_PASS=your-smtp-password
   MAIL_FROM=noreply@yourdomain.com
   ```

3. Save the file and restart the SmartINBOX service:
   ```bash
   sudo systemctl restart smartinbox.service
   ```

### Database Configuration

If you're using a custom database:

1. Edit the `.env` file:
   ```bash
   nano /home/yourusername/public_html/smartinbox/.env
   ```

2. Update the database configuration:
   ```
   # Database Configuration
   DATABASE_URL=mysql://username:password@localhost:3306/database_name
   ```

3. Save the file and restart the SmartINBOX service:
   ```bash
   sudo systemctl restart smartinbox.service
   ```

## Managing the SmartINBOX Service

### Using systemd

```bash
# Start the service
sudo systemctl start smartinbox.service

# Stop the service
sudo systemctl stop smartinbox.service

# Restart the service
sudo systemctl restart smartinbox.service

# Check service status
sudo systemctl status smartinbox.service

# View service logs
sudo journalctl -u smartinbox.service
```

### Using the Provided Scripts

```bash
# Start the service
cd /home/yourusername/public_html/smartinbox
./start.sh

# Stop the service
cd /home/yourusername/public_html/smartinbox
./stop.sh
```

### Using PM2 (Alternative)

```bash
# Install PM2 if not already installed
npm install -g pm2

# Start using PM2
cd /home/yourusername/public_html/smartinbox
pm2 start ecosystem.config.js

# Other PM2 commands
pm2 stop smartinbox
pm2 restart smartinbox
pm2 status
pm2 logs smartinbox
```

## Troubleshooting

### Common Issues

1. **Service won't start**
   - Check the logs: `sudo journalctl -u smartinbox.service`
   - Verify Node.js is installed: `node -v`
   - Check file permissions: `ls -la /home/yourusername/public_html/smartinbox`

2. **Cannot access the website**
   - Check Apache configuration: `sudo apachectl -t`
   - Verify .htaccess file exists: `cat /home/yourusername/public_html/smartinbox/.htaccess`
   - Check Apache error logs: `tail -f /var/log/apache2/error.log`

3. **API calls failing**
   - Verify the Node.js service is running: `systemctl status smartinbox.service`
   - Check if port 3000 is accessible: `curl http://localhost:3000/api/status`
   - Check proxy settings in .htaccess

4. **Permission issues**
   - Ensure proper ownership: `sudo chown -R yourusername:yourusername /home/yourusername/public_html/smartinbox`
   - Check directory permissions: `sudo chmod -R 755 /home/yourusername/public_html/smartinbox`

### Log Files

- Application logs: `/home/yourusername/public_html/smartinbox/logs/server.out`
- Error logs: `/home/yourusername/public_html/smartinbox/logs/server.err`
- System logs: `sudo journalctl -u smartinbox.service`

## Updating SmartINBOX

To update SmartINBOX to a newer version:

```bash
cd /home/yourusername/public_html/smartinbox
sudo systemctl stop smartinbox.service
cp -r /path/to/new/version/* .
npm install
sudo systemctl start smartinbox.service
```

## Security Recommendations

1. **Update your JWT secrets**
   - Edit the `.env` file and change the JWT_SECRET and SESSION_SECRET values
   - Use strong, random strings for these secrets

2. **Configure firewall rules**
   - Ensure only necessary ports are open (80, 443, 25, 143, 993, 587)
   - Block access to port 3000 from external networks

3. **Set up regular backups**
   - Back up your data directory regularly
   - Back up your database regularly

4. **Keep the system updated**
   - Regularly update Node.js, PHP, and other dependencies
   - Apply security patches promptly

## Support

For support, please contact support@smartinbox.com or visit our website at https://www.smartinbox.com.